/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)

#define MAX_CHANNEL 2       /* Maximum Number of Memory Channels */
#define MAX_DIMM 2          /* Maximum Number of DIMMs PER Memory Channel */
#define MAX_SPD_BYTES 512   /* Maximum Number of SPD bytes */
#define MAX_USB_PORTS 4

/*
* SMBIOS Memory Info structures.
*/
typedef struct {
  UINT8         DimmId;
  UINT32        SizeInMb;
  UINT16        MfgId;
  UINT8         ModulePartNum[20]; /* Module part number for DDR3 is 18 bytes however for DRR4 20 bytes as per JEDEC Spec, so reserving 20 bytes */
} DIMM_INFO;

typedef struct {
  UINT8         ChannelId;
  UINT8         DimmCount;
  DIMM_INFO     DimmInfo[MAX_DIMM];
} CHANNEL_INFO;

typedef struct {
  UINT8         Revision;
  UINT16        DataWidth;
  /** As defined in SMBIOS 3.0 spec
  Section 7.18.2 and Table 75
  **/
  UINT16        MemoryType;
  UINT16        MemoryFrequencyInMHz;
  /** As defined in SMBIOS 3.0 spec
  Section 7.17.3 and Table 72
  **/
  UINT8         ErrorCorrectionType;
  UINT8         ChannelCount;
  CHANNEL_INFO  ChannelInfo[MAX_CHANNEL];
} FSP_SMBIOS_MEMORY_INFO;

typedef struct {
  UINT32        PerfSig;
  UINT16        PerfLen;
  UINT16        Reserved4;
  UINT32        PerfIdx;
  UINT64        PerfData[32];
} FSP_PERF_INFO;

#define BL_MAX_FIA_LANES 24
#define BL_FIA_LANE_OVERRIDE_DISABLED  0xff
#define BL_FIA_LANE_DISABLED           0x0
#define BL_FIA_LANE_PCIE               0x1
#define BL_FIA_LANE_SATA               0x2
#define BL_FIA_LANE_XHCI               0x3
#define BL_FIA_LANE_PCIE_ROOT_PORT_LINK_WIDTH_SET_BY_BICTRL  0x0
#define BL_FIA_LANE_PCIE_ROOT_PORT_LINK_WIDTH_X1             0x1

typedef struct {
  UINT8 FiaLaneConfig[BL_MAX_FIA_LANES];
  UINT8 FiaLaneLinkWidth[BL_MAX_FIA_LANES];
} BL_HSIO_INFORMATION;

/**
  This structure holds the DLL configuration
  register values that will be programmed by RC.
  Those policies should be used by platform if default values
  provided by RC are not sufficient to provide stable operation
  at all supported speed modes. RC will blindly set the DLL values
  as provided in this structure.

  For help with obtaining valid DLL values for your platform please
  contact enabling support.
**/
typedef struct {
  UINT32  TxCmdDelayControl;      // Offset 820h: Tx CMD Delay Control
  UINT32  TxDataDelayControl1;    // Offset 824h: Tx Data Delay Control 1
  UINT32  TxDataDelayControl2;    // Offset 828h: Tx Data Delay Control 2
  UINT32  RxCmdDataDelayControl1; // Offset 82Ch: Rx CMD + Data Delay Control 1
  UINT32  RxCmdDataDelayControl2; // Offset 834h: Rx CMD + Data Delay Control 2
  UINT32  RxStrobeDelayControl;   // Offset 830h: Rx Strobe Delay Control, valid only for eMMC
} BL_SCS_SD_DLL;

/**
  Definition of FIA OVERRIDE STATUS HOB
  Get/Set Status are defined by their respective Get/Set MeFiaMuxConfig functions called in PeiFiaMuxConfigInitLib.

  FIA MUX configuration is based on platform design and generally set by soft straps.
  FIA MUX configuration can change the generic lane assignment through the FSP UPDs to increase flexibility.
  FIA_OVERRIDE_STATUS_HOB allows the FSP to provide the required feedback
    on the update of the FIA MUX configuration to the customer's bootloader.
**/
typedef struct {
  UINT32    FiaMuxConfigGetStatus;     // Status returned by MeFiaMuxConfigGet (MeFiaMuxLib)
  UINT32    FiaMuxConfigSetStatus;     // Status returned by MeFiaMuxConfigSet (MeFiaMuxLib)
  BOOLEAN   FiaMuxConfigSetRequired;   // Indicates that a set was required in the FIA lane assignment.
                                       //   FALSE = the requested config matched the existing one.
                                       //   TRUE  = the requested config did not match the existing one.
} BL_FIA_OVERRIDE_STATUS_HOB;


//
// Data Types
//
#ifndef UINT64_STRUCT_T
#define UINT64_STRUCT_T
typedef union {
  struct {
    UINT32  Low;
    UINT32  High;
  } Data32;
  UINT64 Data;
} BL_UINT64_STRUCT;
#endif // UINT64_STRUCT_T

///
/// RC version number structure.
///
typedef struct {
  UINT8   Major;
  UINT8   Minor;
  UINT8   Revision;
  UINT16  BuildNumber;
} BL_RC_VERSION;

#define BL_MAX_CHA_MAP                 1
#define BL_MAX_FW_KTI_PORTS            3
#define BL_MAX_SOCKET                  1
#define BL_NUMBER_PORTS_PER_SOCKET     5
#define BL_TYPE_MAX_MMIO_BAR           11
#define BL_MAX_IMC                     1
#define BL_MAX_CH                      2
#define BL_MAX_LOGIC_IIO_STACK         8
#define BL_MAX_IIO_STACK               6
#define BL_MaxIIO                      BL_MAX_SOCKET
#define BL_MC_MAX_NODE                 (BL_MAX_SOCKET * BL_MAX_IMC)


typedef struct {
  UINT8                     Valid;         // TRUE, if the link is valid (i.e reached normal operation)
  UINT8                     PeerSocId;     // Socket ID
  UINT8                     PeerSocType;   // Socket Type (0 - CPU; 1 - IIO)
  UINT8                     PeerPort;      // Port of the peer socket
}BL_QPI_PEER_DATA;

typedef struct {
  UINT8                     Valid;
  UINT32                    MmioBar[BL_TYPE_MAX_MMIO_BAR];
  UINT8                     PcieSegment;
  BL_UINT64_STRUCT          SegMmcfgBase;
  UINT16                    stackPresentBitmap;
  UINT16                    M2PciePresentBitmap;
  UINT8                     TotM3Kti;
  UINT8                     TotCha;
  UINT32                    ChaList[BL_MAX_CHA_MAP];
  UINT32                    SocId;
  BL_QPI_PEER_DATA          PeerInfo[BL_MAX_FW_KTI_PORTS];    // QPI LEP info
} BL_QPI_CPU_DATA;

typedef struct {
  UINT8                     Valid;
  UINT8                     SocId;
  BL_QPI_PEER_DATA          PeerInfo[BL_MAX_SOCKET];    // QPI LEP info
} BL_QPI_IIO_DATA;

typedef struct {
  UINT8       Device;
  UINT8       Function;
} BL_IIO_PORT_INFO;

typedef struct {
  BL_IIO_PORT_INFO        PortInfo[BL_NUMBER_PORTS_PER_SOCKET];
} BL_IIO_DMI_PCIE_INFO;

typedef struct _BL_STACK_RES {
  UINT8                   Personality;           // Refer to BL_STACK_TYPE for the meaning of this field.
  UINT8                   BusBase;
  UINT8                   BusLimit;
  UINT16                  PciResourceIoBase;
  UINT16                  PciResourceIoLimit;
  UINT32                  IoApicBase;
  UINT32                  IoApicLimit;
  UINT32                  Mmio32Base;            // Base of low MMIO configured for this stack in memory map
  UINT32                  Mmio32Limit;           // Limit of low MMIO configured for this stack in memory map
  UINT64                  Mmio64Base;            // Base of high MMIO configured for this stack in memory map
  UINT64                  Mmio64Limit;           // Limit of high MMIO configured for this stack in memory map
  UINT32                  PciResourceMem32Base;  // Base of low MMIO resource available for PCI devices
  UINT32                  PciResourceMem32Limit; // Limit of low MMIO resource available for PCI devices
  UINT64                  PciResourceMem64Base;  // Base of high MMIO resource available for PCI devices
  UINT64                  PciResourceMem64Limit; // Limit of high MMIO resource available for PCI devices
  UINT32                  VtdBarAddress;
  UINT32                  Mmio32MinSize;         // Minimum required size of MMIO32 resource needed for this stack
} BL_STACK_RES;

typedef struct {
  UINT8                   Valid;
  UINT8                   SocketID;            // Socket ID of the IIO (0..3)
  UINT8                   BusBase;
  UINT8                   BusLimit;
  UINT16                  PciResourceIoBase;
  UINT16                  PciResourceIoLimit;
  UINT32                  IoApicBase;
  UINT32                  IoApicLimit;
  UINT32                  Mmio32Base;          // Base of low MMIO configured for this socket in memory map
  UINT32                  Mmio32Limit;         // Limit of low MMIO configured for this socket in memory map
  UINT64                  Mmio64Base;          // Base of high MMIO configured for this socket in memory map
  UINT64                  Mmio64Limit;         // Limit of high MMIO configured for this socket in memory map
  BL_STACK_RES            StackRes[BL_MAX_LOGIC_IIO_STACK];
  UINT32                  RcBaseAddress;
  BL_IIO_DMI_PCIE_INFO    PcieInfo;
  UINT8                   DmaDeviceCount;
} BL_IIO_RESOURCE_INSTANCE;

typedef struct {
  UINT16                    PlatGlobalIoBase;       // Global IO Base
  UINT16                    PlatGlobalIoLimit;      // Global IO Limit
  UINT32                    PlatGlobalMmio32Base;   // Global Mmiol base
  UINT32                    PlatGlobalMmio32Limit;  // Global Mmiol limit
  UINT64                    PlatGlobalMmio64Base;   // Global Mmioh Base [43:0]
  UINT64                    PlatGlobalMmio64Limit;  // Global Mmioh Limit [43:0]
  BL_QPI_CPU_DATA           CpuQpiInfo[BL_MAX_SOCKET]; // QPI related info per CPU
  BL_QPI_IIO_DATA           IioQpiInfo[BL_MAX_SOCKET]; // QPI related info per IIO
  UINT32                    MemTsegSize;
  UINT32                    MemIedSize;
  UINT64                    PciExpressBase;
  UINT32                    PciExpressSize;
  UINT32                    MemTolm;
  BL_IIO_RESOURCE_INSTANCE  IIO_resource[BL_MAX_SOCKET];
  UINT8                     numofIIO;
  UINT8                     MaxBusNumber;
  UINT32                    packageBspApicID[BL_MAX_SOCKET]; // This data array is valid only for SBSP, not for non-SBSP CPUs. <AS> for CpuSv
  UINT8                     EVMode;
  UINT8                     Pci64BitResourceAllocation;
  UINT8                     SkuPersonality[BL_MAX_SOCKET];
  UINT8                     VMDStackEnable[BL_MaxIIO][BL_MAX_IIO_STACK];
  UINT16                    IoGranularity;
  UINT32                    MmiolGranularity;
  BL_UINT64_STRUCT          MmiohGranularity;
  UINT8                     RemoteRequestThreshold;  //5370389
  UINT32                    UboxMmioSize;
  UINT32                    MaxAddressBits;
} BL_PLATFORM_DATA;

typedef struct {
    UINT8                   CurrentUpiiLinkSpeed;// Current programmed UPI Link speed (Slow/Full speed mode)
    UINT8                   CurrentUpiLinkFrequency; // Current requested UPI Link frequency (in GT)
    UINT8                   OutKtiCpuSktHotPlugEn;            // 0 - Disabled, 1 - Enabled for PM X2APIC
    UINT32                  OutKtiPerLinkL1En[BL_MAX_SOCKET];    // output kti link enabled status for PM
    UINT8                   IsocEnable;
    UINT32                  meRequestedSize; // Size of the memory range requested by ME FW, in MB
    UINT32                  ieRequestedSize; // Size of the memory range requested by IE FW, in MB
    UINT8                   DmiVc1;
    UINT8                   DmiVcm;
    UINT32                  CpuPCPSInfo;
    UINT8                   cpuSubType;
    UINT8                   SystemRasType;
    UINT8                   numCpus;                                        // 1,..4. Total number of CPU packages installed and detected (1..4)by QPI RC
    UINT16                  tolmLimit;
    UINT32                  tohmLimit;
    BL_RC_VERSION           RcVersion;
    BOOLEAN                 MsrTraceEnable;
    UINT8                   DdrXoverMode;           // DDR 2.2 Mode
    // For RAS
    UINT8                   bootMode;
    UINT8                   OutClusterOnDieEn; // Whether RC enabled COD support
    UINT8                   OutSncEn;
    UINT8                   OutNumOfCluster;
    UINT8                   imcEnabled[BL_MAX_SOCKET][BL_MAX_IMC];
    UINT16                  LlcSizeReg;
    UINT8                   chEnabled[BL_MAX_SOCKET][BL_MAX_CH];
    UINT8                   memNode[BL_MC_MAX_NODE];
    UINT8                   IoDcMode;
    UINT8                   DfxRstCplBitsEn;
} BL_SYSTEM_STATUS;

typedef struct {
    BL_PLATFORM_DATA           PlatformData;
    BL_SYSTEM_STATUS           SystemStatus;
} BL_IIO_UDS;

//PCI MMIO and IO resource reconfiguration
typedef struct {
  UINT16                      IoBase;                              // Base of I/O range assigned to entity
  UINT16                      IoLimit;                             // Limit of I/O range assigned to entity
  UINT32                      LowMmioBase;                         // Base of low MMIO region for entity
  UINT32                      LowMmioLimit;                        // Limit of low MMIO region for entity
  UINT64                      HighMmioBase;                        // Base of high (64-bit) MMIO region for entity
  UINT64                      HighMmioLimit;                       // Limit of high (64-bit) MMIO region for entity
} BL_PCI_BASE_LIMITS;

typedef struct {
  BL_PCI_BASE_LIMITS          StackLimits[BL_MAX_LOGIC_IIO_STACK]; // Base and Limit of all PCIe resources for each stack of the socket
} BL_SOCKET_PCI_BASE_LIMITS;

typedef struct {
  BL_SOCKET_PCI_BASE_LIMITS   Socket[BL_MAX_SOCKET];               // Base and limit of all PCIe resources for each socket
} BL_SYSTEM_PCI_BASE_LIMITS;

typedef enum {
  BL_TYPE_UBOX = 0,
  BL_TYPE_UBOX_IIO,
  BL_TYPE_MCP,
  BL_TYPE_FPGA,
  BL_TYPE_HFI,
  BL_TYPE_NAC,
  BL_TYPE_GRAPHICS,
  BL_TYPE_DINO,
  BL_TYPE_RESERVED,
  BL_TYPE_DISABLED,              // This item must be prior to stack specific disable types
  BL_TYPE_UBOX_IIO_DIS,
  BL_TYPE_MCP_DIS,
  BL_TYPE_FPGA_DIS,
  BL_TYPE_HFI_DIS,
  BL_TYPE_NAC_DIS,
  BL_TYPE_GRAPHICS_DIS,
  BL_TYPE_DINO_DIS,
  BL_TYPE_RESERVED_DIS,
  BL_TYPE_NONE
} BL_STACK_TYPE;              // This enumeration defines the "Personality" of a given stack.


/** FSP-M Configuration
**/
typedef struct {

/** Offset 0x0040 - Enable BIOS SSA RMT
  Enables/Disables SSA RMT. Please refer to the Integration guide for RMT details.
  $EN_DIS
**/
  UINT8                       PcdEnableBiosSsaRMT;

/** Offset 0x0041 - Enable BIOS SSA RMT on Fast Cold Boot
  Enables/Disables SSA RMT on a Fast Cold Boot
  $EN_DIS
**/
  UINT8                       PcdEnableBiosSsaRMTonFCB;

/** Offset 0x0042 - Enable RMT per Bit Margining
  Enables/Disables Per Bit Margining
  $EN_DIS
**/
  UINT8                       PcdBiosSsaPerBitMargining;

/** Offset 0x0043 - Enable SSA Tables Display
  Enables/Disables displaying results as tables
  $EN_DIS
**/
  UINT8                       PcdBiosSsaDisplayTables;

/** Offset 0x0044 - Enable SSA Plot Display
  Enables/Disables the display of per bit results as plots
  $EN_DIS
**/
  UINT8                       PcdBiosSsaPerDisplayPlots;

/** Offset 0x0045 - Loop count for rank test
  Exponential loop count for a single rank test
**/
  UINT8                       PcdBiosSsaLoopCount;

/** Offset 0x0046 - Enable Backside Margining
  Enables/Disables margin test on the register or buffer backside
  $EN_DIS
**/
  UINT8                       PcdBiosSsaBacksideMargining;

/** Offset 0x0047 - Enable Early Read ID Margining
  Enables/Disables PMem Early Read Id Test
  $EN_DIS
**/
  UINT8                       PcdBiosSsaEarlyReadIdMargining;

/** Offset 0x0048 - Enable Step Size Override
  Enables/Disables overriding the default step sizes
  $EN_DIS
**/
  UINT8                       PcdBiosSsaStepSizeOverride;

/** Offset 0x0049 - Step size RxDqs
  Step size of RxDqs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaRxDqs;

/** Offset 0x004A - Step size RxVrefs
  Step size of RxVrefs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaRxVref;

/** Offset 0x004B - Step size TxDqs
  Step size of TxDqs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaTxDq;

/** Offset 0x004C - Step size TxVrefs
  Step size of TxVrefs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaTxVref;

/** Offset 0x004D - Step size CmdAll
  Step size of CmdAll. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaCmdAll;

/** Offset 0x004E - Step size CmdVref
  Step size of CmdVref. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaCmdVref;

/** Offset 0x004F - Step size CtlAll
  Step size of CtlAll. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaCtlAll;

/** Offset 0x0050 - Step size EridDelay
  Step size of EridDelay. Auto:1. Supported values : 1,2,4,8. This option is valid
  only if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaEridDelay;

/** Offset 0x0051 - Step size EridVref
  Step size of EridVref. Auto:1. Supported values : 1,2,4,8. This option is valid
  only if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaEridVref;

/** Offset 0x0052 - Enable SSA RMT Debug Message
  Enables the BSSA RMT debug messages
  2:Disable, 5:Enable
**/
  UINT8                       PcdBiosSsaDebugMessages;

/** Offset 0x0053
**/
  UINT8                       UnusedUpdSpace0[13];

/** Offset 0x0060 - ECC Support
  Enable/disable ECC Support.
  $EN_DIS
**/
  UINT8                       PcdEccSupport;

/** Offset 0x0061 - Fast Boot
  Enable/Disable Fast Boot.
  0:Disabled,1:Enabled
**/
  UINT8                       PcdFastBoot;

/** Offset 0x0062 - Memory Test
  Enable/Disable Memory Test.
  $EN_DIS
**/
  UINT8                       PcdMemTest;

/** Offset 0x0063 - Memory Turnaround Time Optimization
  Enable/Disable Memory turnaround time optimization.
  $EN_DIS
**/
  UINT8                       PcdMemTurnaroundOpt;

/** Offset 0x0064 - Memory Frequency
  Set DDR Memory Frequency Limit
  0: AUTO, 4:1200, 5:1333, 6:1400, 7:1600, 8:1800, 9:1866, 11:2133, 12:2200, 13:2400,
  14:2600, 15:2666, 16:2800, 17: 2933
**/
  UINT8                       PcdDdrFreq;

/** Offset 0x0065 - Memory Command Timing
  Select the desired memory controller command timing
  0:Auto, 1:1N, 2:2N, 3:3N
**/
  UINT8                       PcdCommandTiming;

/** Offset 0x0066 - Memory Custom Refresh Rate
  Set Desired rate in 0.1x units of the standard 7.8 usec interval. The valid range
  is 20 - 80(i.e. 2x to 8x)
**/
  UINT8                       PcdCustomRefreshRate;

/** Offset 0x0067 - TSEG size
  Configure TSEG size in MB.
  1:8M, 2:16M, 3:32M, 4:64M, 5:128M
**/
  UINT8                       PcdTsegSize;

/** Offset 0x0068
**/
  UINT8                       UnusedUpdSpace1[40];

/** Offset 0x0090 - HSUART Device
  Select the PCI High Speed UART Device for Serial Port.
  0:HSUART0, 1:HSUART1, 2:HSUART2
**/
  UINT8                       PcdHsuartDevice;

/** Offset 0x0091 - ME Heci Communication
  Enable/Disable ME Heci Communication.
  0:Disabled,1:Enabled
**/
  UINT8                       PcdHeciCommunication;

/** Offset 0x0092 - Virtualization Technology for Directed I/O
  Enable/Disable Virtualization Technology for Directed I/O.
  $EN_DIS
**/
  UINT8                       PcdVtdSupport;

/** Offset 0x0093 - Enable USB3 Ports
  Enable/Disable per USB3 Ports. One byte for each port, byte0 for port0, byte1 for
  port1 and so on.
**/
  UINT32                      PcdPchUsb3Port;

/** Offset 0x0097 - Enable USB2 Ports
  Enable/Disable per USB2 Ports. One byte for each port, byte0 for port0, byte1 for
  port1 and so on.
**/
  UINT32                      PcdPchUsb2Port;

/** Offset 0x009B - Enable USB3 Port Over Current Configuration
  Enable over current pin assignment per USB3 port. 0xFF mean skip over current pin.
  One byte for each port, byte0 for port0, byte1 for port1 and so on
**/
  UINT32                      PcdPchUsb3PortOc;

/** Offset 0x009F - Enable USB2 Port Over Current Configuration
  Enable over current pin assignment per USB2 port. 0xFF mean skip over current pin.
  One byte for each port, byte0 for port0, byte1 for port1 and so on
**/
  UINT32                      PcdPchUsb2PortOc;

/** Offset 0x00A3 - USB2 Per Port HS Pre-emphasis Bias
  USB2 Per Port HS Pre-emphasis Bias. 000b - 0mV, 001b - 11.25mV, 010b - 16.9mV, 011b
  - 28.15mV, 100b - 28.15mV, 101b - 39.35mV, 110b - 45mV, 111b - 56.3mV. One byte
  for each port.
**/
  UINT32                      PcdUsb2PeTxiSet;

/** Offset 0x00A7 - USB2 Per Port HS Transmitter Bias
  USB2 Per Port HS Transmitter Bias. 000b - 0mV, 001b - 11.25mV, 010b - 16.9mV, 011b
  - 28.15mV, 100b - 28.15mV, 101b - 39.35mV, 110b - 45mV, 111b - 56.3mV. One byte
  for each port.
**/
  UINT32                      PcdUsb2TxiSet;

/** Offset 0x00AB - USB2 Per Port HS Transmitter Emphasis
  USB2 Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT32                      PcdUsb2PreDeEmp;

/** Offset 0x00AF - USB2 Per Port Half Bit Pre-emphasis
  USB2 Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT32                      PcdUsb2PreEmpHalfBit;

/** Offset 0x00B3 - IIO PCIe Port 1 Bifurcation
  IIO PCI Express port bifurcation for selected slot(s).
  0xFF:Auto, 0:X4X4X4X4, 1:X4X4X8, 2:X8X4X4, 3:X8X8, 4:X16
**/
  UINT8                       PcdIIOPciePortBifurcation;

/** Offset 0x00B4 - IIO PCIe R-Link DeEmphasis
  Desired DeEmphasis level for IIO PCIe R-Link
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPcieRLinkDeEmphasis;

/** Offset 0x00B5 - IIO PCIe Port 1A DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1A
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1ADeEmphasis;

/** Offset 0x00B6 - IIO PCIe Port 1B DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1B
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1BDeEmphasis;

/** Offset 0x00B7 - IIO PCIe Port 1C DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1C
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1CDeEmphasis;

/** Offset 0x00B8 - IIO PCIe Port 1D DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1D
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1DDeEmphasis;

/** Offset 0x00B9 - IIO PCIe R-Link Link Speed
  Desired Link Speed for IIO PCIe R-Link
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdIIoPcieLinkSpeedRLink;

/** Offset 0x00BA - IIO PCIe Port 1A Link Speed
  Desired Link Speed for IIO PCIe Port 1A
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdIIoPciePort1ALinkSpeed;

/** Offset 0x00BB - IIO PCIe Port 1B Link Speed
  Desired Link Speed for IIO PCIe Port 1B
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdIIoPciePort1BLinkSpeed;

/** Offset 0x00BC - IIO PCIe Port 1C Link Speed
  Desired Link Speed for IIO PCIe Port 1C
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdIIoPciePort1CLinkSpeed;

/** Offset 0x00BD - IIO PCIe Port 1D Link Speed
  Desired Link Speed for IIO PCIe Port 1D
  1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdIIoPciePort1DLinkSpeed;

/** Offset 0x00BE - IIO PCIe R-Link Aspm
  Desired Active state power management settings for IIO PCIe R-Link
  0:Disabled,2:L1
**/
  UINT8                       PcdIIoPcieRLinkAspm;

/** Offset 0x00BF - IIO PCIe Port 1A Aspm
  Desired Active state power management settings for IIO PCIe Port 1A
  0:Disabled,2:L1
**/
  UINT8                       PcdIIoPciePort1AAspm;

/** Offset 0x00C0 - IIO PCIe Port 1B Aspm
  Desired Active state power management settings for IIO PCIe Port 1B
  0:Disabled,2:L1
**/
  UINT8                       PcdIIoPciePort1BAspm;

/** Offset 0x00C1 - IIO PCIe Port 1C Aspm
  Desired Active state power management settings for IIO PCIe Port 1C
  0:Disabled,2:L1
**/
  UINT8                       PcdIIoPciePort1CAspm;

/** Offset 0x00C2 - IIO PCIe Port 1D Aspm
  Desired Active state power management settings for IIO PCIe Port 1D
  0:Disabled,2:L1
**/
  UINT8                       PcdIIoPciePort1DAspm;

/** Offset 0x00C3 - PCH PCIe Controller 0 Bifurcation
  Configure PCI Express controller 0 bifurcation.
  0: Auto, 5:4x2, 6:1x4 2x2, 7:2x2 1x4, 8:2x4, 9:1x8
**/
  UINT8                       PcdBifurcationPcie0;

/** Offset 0x00C4 - PCH PCIe Controller 2 Bifurcation
  Configure PCI Express controller 2 bifurcation.
  0: Auto, 5:4x2, 6:1x4 2x2, 7:2x2 1x4, 8:2x4, 9:1x8
**/
  UINT8                       PcdBifurcationPcie2;

/** Offset 0x00C5
**/
  UINT8                       UnusedUpdSpace2[107];

/** Offset 0x0130 - Customer Revision
  The Customer can set this revision string for their own purpose.
**/
  UINT8                       PcdCustomerRevision[32];

/** Offset 0x0150 - Memory Thermal Throttling
  Enable/disable Memory Thermal Throttling
  0:Disabled,2:Enabled
**/
  UINT8                       PcdMemoryThermalThrottling;

/** Offset 0x0151
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x0152
**/
  UINT8                       PcdFiaMuxOverride;

/** Offset 0x0153
**/
  UINT8                       FiaMuxCfgInvalidate;

/** Offset 0x0154
**/
  UINT8                       UnusedUpdSpace4[3];

/** Offset 0x0157 - PCH Trace Hub Enable Mode
  Select Host or Target for Trace Hub debugger tool. Refer to Integration guide.
  0:Disable, 1:Target debugger, 2:Host debugger
**/
  UINT8                       PcdPchTraceHubMode;

/** Offset 0x0158 - PCH TH Mem Buffer Size 0
  Select size of memory region 0 buffer. Refer to Integration guide.
  0:None/OS, 1:1 MB, 2:8 MB, 3:64 MB, 4:128 MB, 5:256 MB, 6:512 MB
**/
  UINT8                       PcdPchTraceHubMemReg0Size;

/** Offset 0x0159 - PCH TH Mem Buffer Size 1
  Select size of memory region 1 buffer. Refer to Integration guide
  0:None/OS, 1:1 MB, 2:8 MB, 3:64 MB, 4:128 MB, 5:256 MB, 6:512 MB
**/
  UINT8                       PcdPchTraceHubMemReg1Size;

/** Offset 0x015A
**/
  UINT8                       UnusedUpdSpace5;

/** Offset 0x015B - IMR3 Enable
  Enable/Disable IMR3 .Default is Disabled .Refer to Integration guide
  $EN_DIS
**/
  UINT8                       PcdEnableIMR3;

/** Offset 0x015C - Processor X2APIC Enable
  Enable / Disable Processor X2APIC. Refer to Integration guide
  $EN_DIS
**/
  UINT8                       PcdProcessorX2Apic;

/** Offset 0x015D - Hyper Threading Enable/Disable
  Enable or Disable Hyper Threading; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PcdHyperThreading;

/** Offset 0x015E - PCIe Hot Plug Enable
  Enable / Disable PCIe Hot Plug.
  $EN_DIS
**/
  UINT8                       PcdPcieHotPlugEnable;

/** Offset 0x015F - PCIe Acpi Hot Plug Enable
  Enable / Disable PCIe Acpi Hot Plug.
  $EN_DIS
**/
  UINT8                       PcdPcieAcpiHotPlugEnable;

/** Offset 0x0160
**/
  UINT8                       UnusedUpdSpace6;

/** Offset 0x0161 - IIO PCIe Port 1A Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1A
  0:Disable, 1:Enable
**/
  UINT8                       PcdIIoPciePort1AHPCapable;

/** Offset 0x0162 - IIO PCIe Port 1B Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1B
  0:Disable, 1:Enable
**/
  UINT8                       PcdIIoPciePort1BHPCapable;

/** Offset 0x0163 - IIO PCIe Port 1C Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1C
  0:Disable, 1:Enable
**/
  UINT8                       PcdIIoPciePort1CHPCapable;

/** Offset 0x0164 - IIO PCIe Port 1D Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1D
  0:Disable, 1:Enable
**/
  UINT8                       PcdIIoPciePort1DHPCapable;

/** Offset 0x0165
**/
  UINT8                       UnusedUpdSpace7;

/** Offset 0x0166 - IIO PCIe Port 1A Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1A
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1AHPSurprise;

/** Offset 0x0167 - IIO PCIe Port 1B Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1B
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1BHPSurprise;

/** Offset 0x0168 - IIO PCIe Port 1C Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1C
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1CHPSurprise;

/** Offset 0x0169 - IIO PCIe Port 1D Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1D
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1DHPSurprise;

/** Offset 0x016A
**/
  UINT8                       UnusedUpdSpace8[102];

/** Offset 0x01D0
**/
  UINT32                      PcdIioResConfigPtr;

/** Offset 0x01D4
**/
  UINT32                      PcdFiaLaneConfigPtr;

/** Offset 0x01D8
**/
  UINT32                      PcdKtiBufferPtr;

/** Offset 0x01DC
**/
  UINT32                      PcdMemSpdPtr;

/** Offset 0x01E0
**/
  UINT8                       ReservedMemoryInitUpd[16];
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x01F0
**/
  UINT8                       UnusedUpdSpace9[14];

/** Offset 0x01FE
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
