/*
 *  Copyright (c) 2021 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */
#include "net/dcsctp/packet/error_cause/no_user_data_cause.h"

#include <cstdint>
#include <vector>

#include "net/dcsctp/common/internal_types.h"
#include "net/dcsctp/testing/testing_macros.h"
#include "test/gtest.h"

namespace dcsctp {
namespace {

TEST(NoUserDataCauseTest, SerializeAndDeserialize) {
  NoUserDataCause parameter(TSN(123));

  std::vector<uint8_t> serialized;
  parameter.SerializeTo(serialized);

  ASSERT_HAS_VALUE_AND_ASSIGN(NoUserDataCause deserialized,
                              NoUserDataCause::Parse(serialized));

  EXPECT_EQ(*deserialized.tsn(), 123u);
}

}  // namespace
}  // namespace dcsctp
