"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.axesRectifyFeatureVariation = exports.cleanupGsubGposData = void 0;
const shared_1 = require("../../shared");
function cleanupGsubGposData(table, newTable, lookupCorrespondence, fnRemovable) {
    const lookups = [];
    for (const lookup of [...lookupCorrespondence.values()]) {
        if (!fnRemovable(lookup))
            lookups.push(lookup);
    }
    newTable.lookups = lookups;
    const lookupSet = new Set(lookups);
    if (!lookupSet.size)
        return null;
    const featureCorrespondence = new Map();
    newTable.features = shared_1.RectifyImpl.Elim.listSomeT(table.features, cleanupFeature, lookupCorrespondence, lookupSet, featureCorrespondence, !!table.featureVariations);
    const featureSet = new Set(newTable.features);
    newTable.scripts = shared_1.RectifyImpl.Elim.comapSomeT(table.scripts, cleanupScript, featureCorrespondence);
    if (table.featureVariations) {
        newTable.featureVariations = shared_1.RectifyImpl.Elim.listSomeT(table.featureVariations, cleanupFeatureVariation, lookupCorrespondence, lookupSet, featureCorrespondence, featureSet);
        if (!newTable.featureVariations.length)
            newTable.featureVariations = null;
    }
    return newTable;
}
exports.cleanupGsubGposData = cleanupGsubGposData;
function cleanupFeature(ft, lookupCorrespondence, ls, featureCorrespondence, keepEmptyFeature) {
    const l1 = shared_1.RectifyImpl.Elim.listSome(ft.lookups.map(l => lookupCorrespondence.get(l)), ls);
    if (!keepEmptyFeature && !l1.length)
        return null;
    const ft1 = { ...ft, lookups: l1 };
    featureCorrespondence.set(ft, ft1);
    return ft1;
}
function cleanupLanguage(la, fs) {
    if (!la)
        return null;
    const requiredFeature1 = shared_1.RectifyImpl.Elim.findInMap(la.requiredFeature, fs);
    const features1 = shared_1.RectifyImpl.Elim.listSomeT(la.features, f => shared_1.RectifyImpl.Elim.findInMap(f, fs));
    if (!features1.length && !requiredFeature1)
        return null;
    return { requiredFeature: requiredFeature1, features: features1 };
}
function cleanupScript(sc, fs) {
    const defaultLanguage = cleanupLanguage(sc.defaultLanguage, fs);
    const languages = shared_1.RectifyImpl.Elim.comapSomeT(sc.languages, cleanupLanguage, fs);
    if (!defaultLanguage && !languages.size)
        return null;
    else
        return { defaultLanguage, languages };
}
function cleanupFeatureVariation(fv, lookupCorrespondence, ls, featureCorrespondence, fs) {
    const subst = new Map();
    for (const [from, to] of fv.substitutions) {
        const from1 = shared_1.RectifyImpl.Elim.findInSet(featureCorrespondence.get(from) || from, fs);
        const to1 = cleanupFeature(to, lookupCorrespondence, ls, featureCorrespondence, true);
        if (from1 && to1)
            subst.set(from1, to1);
    }
    if (!subst.size)
        return null;
    else
        return { ...fv, substitutions: subst };
}
function axesRectifyFeatureVariation(rec, fv) {
    fv.conditions = shared_1.RectifyImpl.listSomeT(rec, fv.conditions, (r, c) => {
        const a1 = r.dim(c.dim);
        if (a1)
            return { ...c, dim: a1 };
        else
            return null;
    });
}
exports.axesRectifyFeatureVariation = axesRectifyFeatureVariation;
//# sourceMappingURL=cleanup.js.map