import { Frag } from "@ot-builder/bin-util";
import { Cff } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { CffDrawCallRaw } from "../char-string/write/draw-call";
import { CffReadContext } from "../context/read";
import { CffWriteContext } from "../context/write";
import { DictEncoder } from "./encoder";
import { CffDictDataCollector, CffDictInterpreter, CffDictInterpreterBase } from "./general";
export declare class CffFontDictInterpreterBase extends CffDictInterpreterBase {
    protected ctx: CffReadContext;
    constructor(ctx: CffReadContext);
    protected fd: Cff.FontDict;
    protected popString(): string;
    protected doOperator(opCode: number, flags?: Data.Maybe<number[]>): void;
}
export declare class CffFontDictInterpreter extends CffFontDictInterpreterBase implements CffDictInterpreter<Cff.FontDict> {
    getResult(): Cff.FontDict;
}
export declare class CffFontDictDataCollector extends CffDictDataCollector<Cff.FontDict> {
    private emitNum;
    private emitString;
    collectDrawCalls(pd: Cff.FontDict, ctx: CffWriteContext, rest: void): Generator<CffDrawCallRaw, void, unknown>;
    processPointers(encoder: DictEncoder, fd: Cff.FontDict, ctx: CffWriteContext, rest: void): void;
}
export declare const CffFontDictIo: {
    write(target: Frag, t: Cff.FontDict, ctx: CffWriteContext, rest: void): void;
    read(view: import("@ot-builder/bin-util").BinaryView, ctx: CffReadContext, dictSize: number): Cff.FontDict;
};
export declare const CffFdArrayIo: {
    write(target: Frag, t: Cff.FontDict[], ctx: CffWriteContext): void;
    read(view: import("@ot-builder/bin-util").BinaryView, ctx: CffReadContext): Cff.FontDict[];
};
//# sourceMappingURL=font-dict.d.ts.map