"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LigCaretList = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ImpLib = require("@ot-builder/common-impl");
const errors_1 = require("@ot-builder/errors");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
const coverage_1 = require("../shared/coverage");
const lig_glyph_1 = require("./lig-glyph");
exports.LigCaretList = {
    ...(0, bin_util_1.Read)((view, gOrd, ivs) => {
        const gidCov = view.ptr16().next(coverage_1.GidCoverage);
        const glyphCount = view.uint16();
        errors_1.Assert.SizeMatch("AttachList::glyphCount", glyphCount, gidCov.length);
        const lcl = new Map();
        for (const gid of gidCov) {
            const glyph = gOrd.at(gid);
            const carets = postReadCaretList(glyph, view.ptr16().next(lig_glyph_1.LigGlyph, ivs));
            lcl.set(glyph, carets);
        }
        return lcl;
    }),
    ...(0, bin_util_1.Write)((frag, lcl, cfg, gOrd, ivs) => {
        const trick = cfg.layout.gdefWriteTrick || 0;
        const { gidList, values: points } = coverage_1.CovUtils.splitListFromMap(lcl, gOrd);
        frag.ptr16New().push(coverage_1.GidCoverage, gidList, trick);
        frag.uint16(gidList.length);
        for (const [gid, pl] of ImpLib.Iterators.ZipWithIndex(gidList, points)) {
            frag.ptr16New().push(lig_glyph_1.LigGlyph, pl, ivs);
        }
    })
};
function postReadCaretList(glyph, carets) {
    const results = [];
    for (const caret of carets)
        results.push(computeCaretXFromPointAttachment(glyph, caret));
    return results;
}
function computeCaretXFromPointAttachment(glyph, caret) {
    if (!caret.pointAttachment)
        return caret;
    const glyphPoints = ot_glyphs_1.OtGeometryUtil.apply(ot_glyphs_1.OtGeometryUtil.ListPoint, glyph.geometry);
    if (!glyphPoints || caret.pointAttachment.pointIndex >= glyphPoints.length)
        return caret;
    return { ...caret, x: glyphPoints[caret.pointAttachment.pointIndex].x };
}
//# sourceMappingURL=lig-caret-list.js.map