/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett A C Sheffield <bacs@librecast.net> */

#include "test.h"
#include <state.h>
#include <inttypes.h>

#define SI_UNITS \
	X(' ', 1) \
	X('K', 1000) \
	X('M', 1000000) \
	X('G', 1000000000) \
	X('T', 1000000000000)

static int test_bpslimit_option_set(char si)
{
	uint64_t mult;
#define X(a, b) \
	if (si == a) mult = b;
	SI_UNITS
#undef X
	state_t state = {0};
	char bpslimit[] = "42 ";
	char *argv[] = { PACKAGE_NAME, "send", "--bpslimit", bpslimit, NULL };
	int argc = sizeof argv / sizeof argv[0] - 1;
	int rc;

	bpslimit[2] = si;
	test_log("%s %s\n", argv[2], argv[3]);
	rc = state_parse_args(&state, argc, argv);
	if (!test_assert(rc == 0, "state_parse_args() returned %i", rc)) return test_status;
	test_assert(state.bpslimit == 42 * mult, "state.bpslimit = %" PRIu64 "", state.bpslimit);

	return test_status;
}

/* combine --bpslimit with other options */
static int test_bpslimit_and_loopback(void)
{
	state_t state = {0};
	char *argv[] = { PACKAGE_NAME, "send", "-v", "--loopback", "--bpslimit", "123", NULL };
	int argc = sizeof argv / sizeof argv[0] - 1;
	int rc;

	rc = state_parse_args(&state, argc, argv);
	if (!test_assert(rc == 0, "state_parse_args() returned %i", rc)) return test_status;
	test_assert(state.bpslimit == 123, "state.bpslimit = %" PRIu64 "", state.bpslimit);

	return test_status;
}

int main(void)
{
	char name[] = "--bpslimit option";

	test_name(name);

	if (test_bpslimit_option_set(' ')) return test_status;
	if (test_bpslimit_option_set('K')) return test_status;
	if (test_bpslimit_option_set('M')) return test_status;
	if (test_bpslimit_option_set('G')) return test_status;
	if (test_bpslimit_option_set('T')) return test_status;
	if (test_bpslimit_and_loopback()) return test_status;

	return test_status;
}
