.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbFindOverlayForKey __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbFindOverlayForKey \- Find the alternate name by using the primary name for a
key that is part of an overlay
.SH SYNOPSIS
.HP
.B char * XkbFindOverlayForKey
.BI "(\^XkbGeometryPtr " "geom" "\^,"
.BI "XkbSectionPtr " "section" "\^,"
.BI "_Xconst char *" "under" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I geom
geometry that contains the section
.TP
.I section
section to be searched for matching keys
.TP
.I under
primary name of the key to be considered
.SH DESCRIPTION
.LP
Keys that can generate multiple keycodes may be associated with multiple names.
Such keys have a primary name and an alternate name.

.I XkbFindOverlayForKey
uses the primary name of the key,
.I under,
to look up the alternate name, which it returns.
