#! /bin/bash

ProgName=$1

if [ "x${ProgName}" != "xMineXpert3" ]; then
	if [ "x${ProgName}" != "xMassXpert3" ]; then
		echo "ProgName was ${ProgName}"
		echo "unique argument must be either MassXpert3 or MineXpert3."
		exit 1
	fi
fi

if [ ! -d "16x16" ]; then
	echo "Please change directory to 'development/images/icons/' for the project."
	exit 1
fi

command="icotool -c 16x16/${ProgName}.png 32x32/${ProgName}.png 48x48/${ProgName}.png 64x64/${ProgName}.png 128x128/${ProgName}.png -o ${ProgName}.ico"
printf "Running: ${command}... "
eval ${command}
if [ "$?" = "0" ]; then
	echo "Success"
else
	echo "Failure"
fi
