%feature("docstring") OT::GeometricFactory
R"RAW(Geometric factory.

Notes
-----
We use the following estimator:

.. math::
    :nowrap:

    \begin{eqnarray*}
      \displaystyle\Hat{p}_n = \frac{1}{\bar{x}_n}
    \end{eqnarray*}

See also
--------
DistributionFactory, Geometric)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeometricFactory::buildAsGeometric
"Estimate the distribution as native distribution.


**Available usages**:

    buildAsGeometric()

    buildAsGeometric(*sample*)

    buildAsGeometric(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : sequence of float
   The parameters of the :class:`~openturns.Geometric`.

Returns
-------
distribution : :class:`~openturns.Geometric`
    The estimated distribution as a Geometric.
    
    In the first usage, the default Geometric distribution is built."

