#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Lego Harry Potter: Years 1-4
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250708.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='lego-harry-potter-years-1-4'
GAME_NAME='Lego Harry Potter: Years 1-4'

ARCHIVE_BASE_0_NAME='setup_lego_harry_potter_1-4_1.0_(17966).exe'
ARCHIVE_BASE_0_MD5='21ddbc82a225687a69044e9baee7109b'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_lego_harry_potter_1-4_1.0_(17966)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='ab78edad26acef08eb3a656dfbdf476e'
ARCHIVE_BASE_0_PART2_NAME='setup_lego_harry_potter_1-4_1.0_(17966)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='0ebb7b7a5772245258e53092c25a4708'
ARCHIVE_BASE_0_SIZE='6300000'
ARCHIVE_BASE_0_VERSION='1.0.0389-gog17966'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/lego_harry_potter_years_14'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
legoharrypotter.exe'
## TODO: Language-specific packages could be built
##       instead of shipping this extra binary.
CONTENT_GAME0_BIN_FILES='
language_setup.exe
language_setup.ini
language_setup.png'
CONTENT_GAME_DATA_FILES='
game.dat
game1.dat
game2.dat
game3.dat
game4.dat
game5.dat
game6.dat'
CONTENT_DOC_DATA_RELATIVE_PATH='docs'
CONTENT_DOC_DATA_FILES='
??/readme.rtf'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/WB Games/LEGO® Harry Potter™'
## Work around shaders compilation errors leading to dangerously messed up rendering,
## including rapidly flashing colourful lights.
##
## 014c:fixme:d3dcompiler:D3DCompile2 Ignoring flags 0x200.
## 014c:err:d3dcompiler:D3DCompile2 Failed to compile shader, vkd3d result -5.
## 014c:err:d3dcompiler:D3DCompile2 Shader log:
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:519:10: E5017: Aborting due to not yet implemented feature: Prioritize between multiple compatible function overloads.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:519:21: E5017: Aborting due to not yet implemented feature: Prioritize between multiple compatible function overloads.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:522:10: E5017: Aborting due to not yet implemented feature: Prioritize between multiple compatible function overloads.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:522:21: E5017: Aborting due to not yet implemented feature: Prioritize between multiple compatible function overloads.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:953:22: W5300: Implicit truncation of vector type.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:986:37: W5300: Implicit truncation of vector type.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:987:37: W5300: Implicit truncation of vector type.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:988:37: W5300: Implicit truncation of vector type.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:989:37: W5300: Implicit truncation of vector type.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:1015:8: W5300: Implicit truncation of vector type.
## 014c:err:d3dcompiler:D3DCompile2     <anonymous>:1224:1: W5300: Implicit truncation of vector type.
## 014c:err:d3dcompiler:D3DCompile2
##
## (WINE 10.0)
WINE_WINETRICKS_VERBS='d3dcompiler_47'

APP_MAIN_EXE='legoharrypotter.exe'

APP_LANGUAGE_ID="${GAME_ID}-language-setup"
APP_LANGUAGE_NAME="$GAME_NAME - Language setup"
APP_LANGUAGE_CAT='Settings'
APP_LANGUAGE_EXE='language_setup.exe'
APP_LANGUAGE_ICON='language_setup.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
