#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Blind Men
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250406.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='blind-men'
GAME_NAME='Blind Men'

ARCHIVE_BASE_0_NAME='Blind_Men-1.3-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='7ad9b061db08427caebbef1650f34004'
ARCHIVE_BASE_0_SIZE='325205'
ARCHIVE_BASE_0_VERSION='1.3-itch.2020.09.25'
ARCHIVE_BASE_0_URL='https://maneatergames.itch.io/blind-men'

CONTENT_PATH_DEFAULT='Blind_Men-1.3-linux/game'
CONTENT_GAME_MAIN_FILES='
cache
images
music
hunter_diamondbranch
images.rpa
scripts.rpa
script_version.txt'

APP_MAIN_TYPE='renpy'

## Ensure easy upgrades from packages generated with pre-20250406.1 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
blind-men-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Write launchers

## Use default Ren'Py icon
desktop_field_icon() {
	printf 'renpy'
}

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
